***********************************************************************
********************DEBT AND CONSUMPTION - Graphs**********************
**************************DATE: MAY 2019 ******************************
************************ AUTHOR: FIONA PRICE **************************
***********************************************************************
clear
set more off
use "C:\UnbalancedHH_analytical NEW.dta", replace

***Graph 1b - HILDA aggregate o-o debt to income***

// aggregate debt to income
gen hdebtnew=hdebt
replace hdebtnew=0 if hdebt==.
g incw = hincome*hhwth 
g hdebtw = hdebtnew*hhwth 
bysort year: egen incsum = sum(incw)
bysort year: egen hdebtsum = sum(hdebtw)
g aggdebtinc = hdebtsum/incsum*100

mat Graph1b = J(17,1,.)
mat rown Graph1b = 2001 2002 2003 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017
mat coln Graph1b = Debt_to_income
tabstat aggdebtinc, by(year) save
forval i=1/17{
mat Graph1b[`i',1]=r(Stat`i')
}
matlist Graph1b

***Graph 2 - non-durable***
mat Graph2a = J(5,3,.)
mat rown Graph2a = 2006 2007 2008 2009 2010
mat coln Graph2a = Highlyindebted Lessindebted Nonindebted

tabstat rexp if maxhaddebt==1 & maxhighly==1 & wave>=6 & wave<=10 [weight=hhwth], by(wave) stat(p50) save
mat Graph2a[1,1]=r(Stat1)
mat Graph2a[2,1]=r(Stat2)
mat Graph2a[3,1]=r(Stat3)
mat Graph2a[4,1]=r(Stat4)
mat Graph2a[5,1]=r(Stat5)
tabstat rexp if maxhaddebt==1 & maxhighly==0 & wave>=6 & wave<=10 [weight=hhwth], by(wave) stat(p50) save
mat Graph2a[1,2]=r(Stat1)
mat Graph2a[2,2]=r(Stat2)
mat Graph2a[3,2]=r(Stat3)
mat Graph2a[4,2]=r(Stat4)
mat Graph2a[5,2]=r(Stat5)
tabstat rexp if maxhaddebt==0 & wave>=6 & wave<=10 [weight=hhwth], by(wave) stat(p50) save
mat Graph2a[1,3]=r(Stat1) 
mat Graph2a[2,3]=r(Stat2)
mat Graph2a[3,3]=r(Stat3)
mat Graph2a[4,3]=r(Stat4)
mat Graph2a[5,3]=r(Stat5)

***Graph 2 - durable***
mat Graph2b = J(5,3,.)
mat rown Graph2b = 2006 2007 2008 2009 2010
mat coln Graph2b = Highlyindebted Lessindebted Nonindebted

tabstat rdurable if maxhaddebt==1 & maxhighly==1 & wave>=6 & wave<=10 [weight=hhwth], by(wave) stat(p50) save
mat Graph2b[1,1]=r(Stat1)
mat Graph2b[2,1]=r(Stat2)
mat Graph2b[3,1]=r(Stat3)
mat Graph2b[4,1]=r(Stat4)
mat Graph2b[5,1]=r(Stat5)
tabstat rdurable if maxhaddebt==1 & maxhighly==0 & wave>=6 & wave<=10 [weight=hhwth], by(wave) stat(p50) save
mat Graph2b[1,2]=r(Stat1)
mat Graph2b[2,2]=r(Stat2)
mat Graph2b[3,2]=r(Stat3)
mat Graph2b[4,2]=r(Stat4)
mat Graph2b[5,2]=r(Stat5)
tabstat rdurable if maxhaddebt==0 & wave>=6 & wave<=10 [weight=hhwth], by(wave) stat(p50) save
mat Graph2b[1,3]=r(Stat1) 
mat Graph2b[2,3]=r(Stat2)
mat Graph2b[3,3]=r(Stat3)
mat Graph2b[4,3]=r(Stat4)
mat Graph2b[5,3]=r(Stat5)

***Graph 2 RESULTS***
matlist Graph2a
matlist Graph2b
********************************************************************************************************************************

**Graph 3a - all households***
mat Graph3a = J(4,2,.)
mat rown Graph3a = 2002 2006 2010 2014
mat coln Graph3a = KVW KVW_adj

tabstat htm htm_adj [weight=hhwth], by(wealthyear) save
mat Graph3a[1,1]=r(Stat1)
mat Graph3a[2,1]=r(Stat2)
mat Graph3a[3,1]=r(Stat3)
mat Graph3a[4,1]=r(Stat4)

**Graph 3b - indebted households***
mat Graph3b = J(4,2,.)
mat rown Graph3b = 2002 2006 2010 2014
mat coln Graph3b = KVW KVW_adj
tabstat htm htm_adj if hdebt!=. [weight=hhwth], by(wealthyear) save
mat Graph3b[1,1]=r(Stat1)
mat Graph3b[2,1]=r(Stat2)
mat Graph3b[3,1]=r(Stat3)
mat Graph3b[4,1]=r(Stat4)

***Graph 3 RESULTS***
matlist Graph3a
matlist Graph3b

********************************************************************************************************************************
sort hhid0 wave
***Graph 4a - start of debt phase***

mat Graph4a = J(7,3,.)
mat rown Graph4a = -3 -2 -1 0 1 2 3
mat coln Graph4a = Income Non-durable Durable

tabstat rinc rexp rdurable if duration>=-3 & duration<=3 [weight=hhwth], by(duration) stat(p50) save
forval i=1/7{
mat Graph4a[`i',1]=r(Stat`i')
}

***Graph 4b - end of debt phase***
mat Graph4b = J(7,3,.)
mat rown Graph4b = -3 -2 -1 0 1 2 3
mat coln Graph4b = Income Non-durable Durable

tabstat rinc rexp rdurable if paidoffdur>=-3 & paidoffdur<=3 [weight=hhwth], by(paidoffdur) stat(p50) save
forval i=1/7{
mat Graph4b[`i',1]=r(Stat`i')
}

***Graph 4 RESULTS***
matlist Graph4a
matlist Graph4b


********************************************************************************************************************************

***Graph 5***
mat Graph5 = J(4,2,.)
mat rown Graph5 = nsw vic qld other
mat coln Graph5 = Before After

tabstat rhdebt if hdebt>0 & nsw==1 & (purchase==2000) & wave==1 [weight=hhwth], stat(mean) save
mat Graph5[1,1]=r(StatTotal)
tabstat rhdebt if hdebt>0 & nsw==1 & (purchase==2001) & wave==2 [weight=hhwth], stat(mean) save
mat Graph5[1,2]=r(StatTotal)
tabstat rhdebt if hdebt>0 & vic==1 & (purchase==2000) & wave==1 [weight=hhwth], stat(mean) save
mat Graph5[2,1]=r(StatTotal)
tabstat rhdebt if hdebt>0 & vic==1 & (purchase==2001) & wave==2 [weight=hhwth], stat(mean) save
mat Graph5[2,2]=r(StatTotal)
tabstat rhdebt if hdebt>0 & qld==1 & (purchase==2000) & wave==1 [weight=hhwth], stat(mean) save
mat Graph5[3,1]=r(StatTotal)
tabstat rhdebt if hdebt>0 & qld==1 & (purchase==2001) & wave==2 [weight=hhwth], stat(mean) save
mat Graph5[3,2]=r(StatTotal)
tabstat rhdebt if hdebt>0 & (other==1|wa==1|sa==1) & (purchase==2001) & wave==2 [weight=hhwth], stat(mean) save
mat Graph5[4,1]=r(StatTotal)
tabstat rhdebt if hdebt>0 & (other==1|wa==1|sa==1) & (purchase==2002) & wave==3 [weight=hhwth], stat(mean) save
mat Graph5[4,2]=r(StatTotal)


***Graph 5 RESULTS***
matlist Graph5
********************************************************************************************************************************

***Graph 6***
local spending rdurable //exp or durable


***Graph 6a - GFC shock***
mat Graph6a = J(7,2,.)
mat rown Graph6a = -3 -2 -1 0 1 2 3
mat coln Graph6a = Indebted Non-indebted
tabstat `spending' if F3.crisis==1 & F3.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6a[1,1]=r(StatTotal)
tabstat `spending' if F2.crisis==1 & F2.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6a[2,1]=r(StatTotal)
tabstat `spending' if F.crisis==1 & F.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6a[3,1]=r(StatTotal)
tabstat `spending' if crisis==1 & hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6a[4,1]=r(StatTotal)
tabstat `spending' if L.crisis==1  & L1.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6a[5,1]=r(StatTotal)
tabstat `spending' if L2.crisis==1  & L2.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6a[6,1]=r(StatTotal)
tabstat `spending' if L3.crisis==1 & L3.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6a[7,1]=r(StatTotal)

tabstat `spending' if F3.crisis==1 & F3.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6a[1,2]=r(StatTotal)
tabstat `spending' if F2.crisis==1 & F2.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6a[2,2]=r(StatTotal)
tabstat `spending' if F.crisis==1 & F.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6a[3,2]=r(StatTotal)
tabstat `spending' if crisis==1 & hdebt==. [weight=hhwth], stat(p50) save
mat Graph6a[4,2]=r(StatTotal)
tabstat `spending' if L.crisis==1  & L1.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6a[5,2]=r(StatTotal)
tabstat `spending' if L2.crisis==1  & L2.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6a[6,2]=r(StatTotal)
tabstat `spending' if L3.crisis==1 & L3.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6a[7,2]=r(StatTotal)

***Graph 6b - local housing price shock shock***
mat Graph6b = J(7,2,.)
mat rown Graph6b = -3 -2 -1 0 1 2 3
mat coln Graph6b = Indebted Non-indebted
tabstat `spending' if F3.neghprice==1 & F3.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6b[1,1]=r(StatTotal)
tabstat `spending' if F2.neghprice==1 & F2.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6b[2,1]=r(StatTotal)
tabstat `spending' if F.neghprice==1 & F.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6b[3,1]=r(StatTotal)
tabstat `spending' if neghprice==1 & hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6b[4,1]=r(StatTotal)
tabstat `spending' if L.neghprice==1  & L1.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6b[5,1]=r(StatTotal)
tabstat `spending' if L2.neghprice==1  & L2.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6b[6,1]=r(StatTotal)
tabstat `spending' if L3.neghprice==1 & L3.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6b[7,1]=r(StatTotal)

tabstat `spending' if F3.neghprice==1 & F3.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6b[1,2]=r(StatTotal)
tabstat `spending' if F2.neghprice==1 & F2.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6b[2,2]=r(StatTotal)
tabstat `spending' if F.neghprice==1 & F.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6b[3,2]=r(StatTotal)
tabstat `spending' if neghprice==1 & hdebt==. [weight=hhwth], stat(p50) save
mat Graph6b[4,2]=r(StatTotal)
tabstat `spending' if L.neghprice==1  & L1.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6b[5,2]=r(StatTotal)
tabstat `spending' if L2.neghprice==1  & L2.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6b[6,2]=r(StatTotal)
tabstat `spending' if L3.neghprice==1 & L3.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6b[7,2]=r(StatTotal)

***Graph 6c - hh unemployment shock***
mat Graph6c = J(7,2,.)
mat rown Graph6c = -3 -2 -1 0 1 2 3
mat coln Graph6c = Indebted Non-indebted
tabstat `spending' if F3.becunemp==1 & F3.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6c[1,1]=r(StatTotal)
tabstat `spending' if F2.becunemp==1 & F2.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6c[2,1]=r(StatTotal)
tabstat `spending' if F.becunemp==1 & F.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6c[3,1]=r(StatTotal)
tabstat `spending' if becunemp==1 & hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6c[4,1]=r(StatTotal)
tabstat `spending' if L.becunemp==1  & L1.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6c[5,1]=r(StatTotal)
tabstat `spending' if L2.becunemp==1  & L2.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6c[6,1]=r(StatTotal)
tabstat `spending' if L3.becunemp==1 & L3.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6c[7,1]=r(StatTotal)

tabstat `spending' if F3.becunemp==1 & F3.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6c[1,2]=r(StatTotal)
tabstat `spending' if F2.becunemp==1 & F2.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6c[2,2]=r(StatTotal)
tabstat `spending' if F.becunemp==1 & F.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6c[3,2]=r(StatTotal)
tabstat `spending' if becunemp==1 & hdebt==. [weight=hhwth], stat(p50) save
mat Graph6c[4,2]=r(StatTotal)
tabstat `spending' if L.becunemp==1  & L1.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6c[5,2]=r(StatTotal)
tabstat `spending' if L2.becunemp==1  & L2.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6c[6,2]=r(StatTotal)
tabstat `spending' if L3.becunemp==1 & L3.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6c[7,2]=r(StatTotal)

***Graph 6d - local unemployment shock***
mat Graph6d = J(7,2,.)
mat rown Graph6d = -3 -2 -1 0 1 2 3
mat coln Graph6d = Indebted Non-indebted
tabstat `spending' if F3.shockdum==1 & F3.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6d[1,1]=r(StatTotal)
tabstat `spending' if F2.shockdum==1 & F2.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6d[2,1]=r(StatTotal)
tabstat `spending' if F.shockdum==1 & F.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6d[3,1]=r(StatTotal)
tabstat `spending' if shockdum==1 & hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6d[4,1]=r(StatTotal)
tabstat `spending' if L.shockdum==1  & L1.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6d[5,1]=r(StatTotal)
tabstat `spending' if L2.shockdum==1  & L2.hdebt!=.  [weight=hhwth], stat(p50) save
mat Graph6d[6,1]=r(StatTotal)
tabstat `spending' if L3.shockdum==1 & L3.hdebt!=. [weight=hhwth], stat(p50) save
mat Graph6d[7,1]=r(StatTotal)

tabstat `spending' if F3.shockdum==1 & F3.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6d[1,2]=r(StatTotal)
tabstat `spending' if F2.shockdum==1 & F2.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6d[2,2]=r(StatTotal)
tabstat `spending' if F.shockdum==1 & F.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6d[3,2]=r(StatTotal)
tabstat `spending' if shockdum==1 & hdebt==. [weight=hhwth], stat(p50) save
mat Graph6d[4,2]=r(StatTotal)
tabstat `spending' if L.shockdum==1  & L1.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6d[5,2]=r(StatTotal)
tabstat `spending' if L2.shockdum==1  & L2.hdebt==.  [weight=hhwth], stat(p50) save
mat Graph6d[6,2]=r(StatTotal)
tabstat `spending' if L3.shockdum==1 & L3.hdebt==. [weight=hhwth], stat(p50) save
mat Graph6d[7,2]=r(StatTotal)

***Graph 6 RESULTS***
matlist Graph6a
matlist Graph6b
matlist Graph6c
matlist Graph6d


